package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

@JsonDeserialize(
    using = Biome.BiomeDeserializer.class
)
@JsonSerialize(
    using = Biome.Serializer.class
)
public interface Biome {
  Ocean getOcean();

  boolean isOcean();

  Jungle getJungle();

  boolean isJungle();

  class Serializer extends StdSerializer<Biome> {
    public Serializer() {
      super(Biome.class);}

    public void serialize(Biome object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isOcean()) {
        jsonGenerator.writeObject(object.getOcean());
        return;
      }
      if ( object.isJungle()) {
        jsonGenerator.writeObject(object.getJungle());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class BiomeDeserializer extends StdDeserializer<Biome> {
    public BiomeDeserializer() {
      super(Biome.class);}

    private boolean looksLikeOcean(Map<String, Object> map) {
      return map.keySet().containsAll(Arrays.asList("id","name","kind","animals")) && map.get("kind").equals("Ocean");
    }

    private boolean looksLikeJungle(Map<String, Object> map) {
      return map.keySet().containsAll(Arrays.asList("id","name","kind","animals")) && map.get("kind").equals("Jungle");
    }

    public Biome deserialize(JsonParser jsonParser, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      ObjectMapper mapper  = new ObjectMapper();
      Map<String, Object> map = mapper.readValue(jsonParser, Map.class);
      if ( looksLikeOcean(map) ) return new BiomeImpl((Ocean)mapper.convertValue(map, BiomeBase.class));
      if ( looksLikeJungle(map) ) return new BiomeImpl((Jungle)mapper.convertValue(map, BiomeBase.class));
      throw new IOException("Can't figure out type of object" + map);
    }
  }
}
