package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(
    using = Biome.BiomeDeserializer.class
)
@JsonSerialize(
    using = Biome.Serializer.class
)
public class BiomeImpl implements Biome {
  private Object anyType;

  private BiomeImpl() {
    this.anyType = null;
  }

  public BiomeImpl(Ocean ocean) {
    this.anyType = ocean;
  }

  public BiomeImpl(Jungle jungle) {
    this.anyType = jungle;
  }

  public Ocean getOcean() {
    if ( !(anyType instanceof  Ocean)) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.Ocean");
    return (Ocean) anyType;
  }

  public boolean isOcean() {
    return anyType instanceof Ocean;
  }

  public Jungle getJungle() {
    if ( !(anyType instanceof  Jungle)) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.Jungle");
    return (Jungle) anyType;
  }

  public boolean isJungle() {
    return anyType instanceof Jungle;
  }
}
