package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

@JsonDeserialize(
    as = JungleImpl.class
)
public interface Jungle extends BiomeBase {
  String _DISCRIMINATOR_TYPE_NAME = "Jungle";

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);

  @JsonProperty("id")
  int getId();

  @JsonProperty("id")
  void setId(int id);

  @JsonProperty("name")
  String getName();

  @JsonProperty("name")
  void setName(String name);

  @JsonProperty("kind")
  String getKind();

  @JsonProperty("animals")
  List<JungleAnimal> getAnimals();

  @JsonProperty("animals")
  void setAnimals(List<JungleAnimal> animals);
}
