package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

@JsonDeserialize(
    as = OceanImpl.class
)
public interface Ocean extends BiomeBase {
  String _DISCRIMINATOR_TYPE_NAME = "Ocean";

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);

  @JsonProperty("id")
  int getId();

  @JsonProperty("id")
  void setId(int id);

  @JsonProperty("name")
  String getName();

  @JsonProperty("name")
  void setName(String name);

  @JsonProperty("kind")
  String getKind();

  @JsonProperty("animals")
  List<OceanAnimal> getAnimals();

  @JsonProperty("animals")
  void setAnimals(List<OceanAnimal> animals);
}
