package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "animalType"
)
@JsonSubTypes({
    @JsonSubTypes.Type(foo.foo.Fish.class),
    @JsonSubTypes.Type(foo.foo.Cat.class),
    @JsonSubTypes.Type(foo.foo.Animal.class)
})
@JsonDeserialize(
    as = AnimalImpl.class
)
public interface Animal {
  String _DISCRIMINATOR_TYPE_NAME = "Animal";

  @JsonProperty("animalType")
  String getAnimalType();

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);
}
