package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonTypeName("myOwnValue")
@JsonPropertyOrder({
    "name",
    "goo"
})
public class FooImpl implements Foo {
  @JsonProperty("name")
  @NotNull
  @Pattern(
      regexp = "a\\[a-z\\]b"
  )
  private String name;

  @NotNull
  @Valid
  @JsonProperty("goo")
  private Foo.GooType goo;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("name")
  public String getName() {
    return this.name;
  }

  @JsonProperty("name")
  public void setName(String name) {
    this.name = name;
  }

  @JsonProperty("goo")
  public Foo.GooType getGoo() {
    return this.goo;
  }

  @JsonProperty("goo")
  public void setGoo(Foo.GooType goo) {
    this.goo = goo;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    FooImpl other = (FooImpl) o;
    return java.util.Objects.equals(this.name, other.name) && java.util.Objects.equals(this.goo, other.goo) && java.util.Objects.equals(this.additionalProperties, other.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name,goo,additionalProperties);
  }

  public static class GooTypeImpl implements Foo.GooType {
    private boolean glue;

    private Foo.GooType.FlueType flue;

    private Map<String, Object> additionalProperties = new ExcludingMap();

    public boolean getGlue() {
      return this.glue;
    }

    public void setGlue(boolean glue) {
      this.glue = glue;
    }

    public Foo.GooType.FlueType getFlue() {
      return this.flue;
    }

    public void setFlue(Foo.GooType.FlueType flue) {
      this.flue = flue;
    }

    public Map<String, Object> getAdditionalProperties() {
      return additionalProperties;
    }

    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }

    public static class FlueTypeImpl implements Foo.GooType.FlueType {
      private String another;

      private Map<String, Object> additionalProperties = new ExcludingMap();

      public String getAnother() {
        return this.another;
      }

      public void setAnother(String another) {
        this.another = another;
      }

      public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
      }

      public void setAdditionalProperties(String key, Object value) {
        this.additionalProperties.put(key, value);
      }
    }
  }
}
