package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(
    using = Biome.Deserializer.class
)
@JsonSerialize(
    using = Biome.Serializer.class
)
public interface Biome {
  UnionType getUnionType();

  boolean isOcean();

  Ocean getOcean();

  boolean isJungle();

  Jungle getJungle();

  class Serializer extends StdSerializer<Biome> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Biome.class);
    }

    public void serialize(Biome object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isOcean()) {
        jsonGenerator.writeObject(object.getOcean());
        return;
      }
      if ( object.isJungle()) {
        jsonGenerator.writeObject(object.getJungle());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<Biome> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(Biome.class);
    }

    private boolean isValidObject(JsonNode node, List<String> keys) {
      List<String> list = new ArrayList<>();
      Iterator<String> fieldIterator = node.fieldNames();
      while (fieldIterator.hasNext()) { list.add(fieldIterator.next()); };
      return list.containsAll(keys);
    }

    public Biome deserialize(JsonParser jp, DeserializationContext jsonContext) throws IOException,
        JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isObject() && isValidObject(node, Arrays.asList("id","name","kind","animals")) && Objects.equals(node.path("kind").asText(), "Ocean")) {
        return new BiomeImpl((Ocean)jp.getCodec().treeToValue(node, BiomeBase.class));
      }
      if (node.isObject() && isValidObject(node, Arrays.asList("id","name","kind","animals")) && Objects.equals(node.path("kind").asText(), "Jungle")) {
        return new BiomeImpl((Jungle)jp.getCodec().treeToValue(node, BiomeBase.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    OCEAN,

    JUNGLE
  }
}
