package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

@JsonDeserialize(
    using = ComplexUnion.Deserializer.class
)
@JsonSerialize(
    using = ComplexUnion.Serializer.class
)
public interface ComplexUnion {
  UnionType getUnionType();

  boolean isBoolean();

  Boolean getBoolean();

  boolean isInteger();

  Integer getInteger();

  boolean isString();

  String getString();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<ComplexUnion> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(ComplexUnion.class);
    }

    public void serialize(ComplexUnion object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isBoolean()) {
        jsonGenerator.writeObject(object.getBoolean());
        return;
      }
      if ( object.isInteger()) {
        jsonGenerator.writeObject(object.getInteger());
        return;
      }
      if ( object.isString()) {
        jsonGenerator.writeObject(object.getString());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<ComplexUnion> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(ComplexUnion.class);
    }

    public ComplexUnion getNullValue(DeserializationContext deserializationContext) {
      return new ComplexUnionImpl(null);
    }

    public ComplexUnion deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new ComplexUnionImpl(null);
      }
      if (node.isBoolean()) {
        return new ComplexUnionImpl(node.asBoolean());
      }
      if (node.isInt()) {
        return new ComplexUnionImpl(node.asInt());
      }
      if (node.isTextual()) {
        return new ComplexUnionImpl(node.asText());
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    BOOLEAN,

    INTEGER,

    STRING,

    NIL
  }
}
