package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonDeserialize(
    using = Date2Union.Deserializer.class
)
@JsonSerialize(
    using = Date2Union.Serializer.class
)
public interface Date2Union {
  UnionType getUnionType();

  boolean isDate();

  Date getDate();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<Date2Union> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Date2Union.class);
    }

    public void serialize(Date2Union object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isDate()) {
        new ObjectMapper().setDateFormat(new SimpleDateFormat("hh:mm:ss")).writeValue(jsonGenerator, object.getDate());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<Date2Union> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(Date2Union.class);
    }

    public Date2Union getNullValue(DeserializationContext deserializationContext) {
      return new Date2UnionImpl(null);
    }

    private boolean isValidDate(String value, DateFormat format) {
      try {
        return format.parse(value) != null;
      }
      catch (ParseException e) {
        return false;
      }
    }

    public Date2Union deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new Date2UnionImpl(null);
      }
      if (node.isTextual() && isValidDate(node.asText(), new SimpleDateFormat("hh:mm:ss"))) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(new SimpleDateFormat("hh:mm:ss"));
        return new Date2UnionImpl(mapper.treeToValue(node, java.sql.Date.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    DATE,

    NIL
  }
}
