package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonDeserialize(
    using = Date3Union.Deserializer.class
)
@JsonSerialize(
    using = Date3Union.Serializer.class
)
public interface Date3Union {
  UnionType getUnionType();

  boolean isDate();

  Date getDate();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<Date3Union> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Date3Union.class);
    }

    public void serialize(Date3Union object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isDate()) {
        new ObjectMapper().setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss")).writeValue(jsonGenerator, object.getDate());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<Date3Union> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(Date3Union.class);
    }

    public Date3Union getNullValue(DeserializationContext deserializationContext) {
      return new Date3UnionImpl(null);
    }

    private boolean isValidDate(String value, DateFormat format) {
      try {
        return format.parse(value) != null;
      }
      catch (ParseException e) {
        return false;
      }
    }

    public Date3Union deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new Date3UnionImpl(null);
      }
      if (node.isTextual() && isValidDate(node.asText(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"))) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        return new Date3UnionImpl(mapper.treeToValue(node, java.sql.Date.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    DATE,

    NIL
  }
}
