package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;

@JsonDeserialize(
    using = Date3Union.Deserializer.class
)
@JsonSerialize(
    using = Date3Union.Serializer.class
)
public class Date3UnionImpl implements Date3Union {
  private Date3Union.UnionType unionType;

  private Date dateValue;

  protected Date3UnionImpl() {
  }

  public Date3UnionImpl(Object value) {
    if (value == null) {
      this.unionType = Date3Union.UnionType.NIL;
    }
    else if (value instanceof Date) {
      this.unionType = Date3Union.UnionType.DATE;
      this.dateValue = (Date) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public Date3Union.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == Date3Union.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isDate() {
    return this.unionType == Date3Union.UnionType.DATE;
  }

  public Date getDate() {
    if (!isDate()) throw new IllegalStateException("fetching wrong type out of the union: java.util.Date");
    return this.dateValue;
  }
}
