package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsonDeserialize(
    using = Date4Union.Deserializer.class
)
@JsonSerialize(
    using = Date4Union.Serializer.class
)
public interface Date4Union {
  UnionType getUnionType();

  boolean isDate();

  Date getDate();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<Date4Union> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Date4Union.class);
    }

    public void serialize(Date4Union object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isDate()) {
        new ObjectMapper().setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ")).writeValue(jsonGenerator, object.getDate());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<Date4Union> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(Date4Union.class);
    }

    public Date4Union getNullValue(DeserializationContext deserializationContext) {
      return new Date4UnionImpl(null);
    }

    private boolean isValidDate(String value, DateFormat format) {
      try {
        return format.parse(value) != null;
      }
      catch (ParseException e) {
        return false;
      }
    }

    public Date4Union deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new Date4UnionImpl(null);
      }
      if (node.isTextual() && isValidDate(node.asText(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"))) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
        return new Date4UnionImpl(mapper.treeToValue(node, java.sql.Date.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    DATE,

    NIL
  }
}
