package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;

@JsonDeserialize(
    as = DogImpl.class
)
public interface Dog {
  @JsonProperty("bark")
  NilBooleanUnion getBark();

  @JsonProperty("bark")
  void setBark(NilBooleanUnion bark);

  @JsonProperty("color")
  String getColor();

  @JsonProperty("color")
  void setColor(String color);

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);

  interface NilBooleanUnion {
    UnionType getUnionType();

    boolean isNil();

    Object getNil();

    boolean isBoolean();

    Boolean getBoolean();

    enum UnionType {
      NIL,

      BOOLEAN
    }
  }
}
