package foo.foo;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonDeserialize(
    using = EntertainementJ1.EntertainementJ1Deserializer.class
)
@JsonSerialize(
    using = EntertainementJ1.Serializer.class
)
public class EntertainementJ1Impl implements EntertainementJ1 {
  private EntertainementJ1.UnionType unionType;

  private ProjectorJ1 projectorJ1Value;

  private TelevisionJ1 televisionJ1Value;

  protected EntertainementJ1Impl() {
  }

  public EntertainementJ1Impl(Object value) {
    if (value instanceof ProjectorJ1) {
      this.unionType = EntertainementJ1.UnionType.PROJECTOR_J1;
      this.projectorJ1Value = (ProjectorJ1) value;
    }
    else if (value instanceof TelevisionJ1) {
      this.unionType = EntertainementJ1.UnionType.TELEVISION_J1;
      this.televisionJ1Value = (TelevisionJ1) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public EntertainementJ1.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isProjectorJ1() {
    return this.unionType == EntertainementJ1.UnionType.PROJECTOR_J1;
  }

  public ProjectorJ1 getProjectorJ1() {
    if (!isProjectorJ1()) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.ProjectorJ1");
    return this.projectorJ1Value;
  }

  public boolean isTelevisionJ1() {
    return this.unionType == EntertainementJ1.UnionType.TELEVISION_J1;
  }

  public TelevisionJ1 getTelevisionJ1() {
    if (!isTelevisionJ1()) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.TelevisionJ1");
    return this.televisionJ1Value;
  }
}
