package foo.foo;

import java.util.ArrayList;
import java.util.Map;

public class InlineChildren extends ArrayList<InlineChildren.ChildType> {
  public interface ChildType extends Child {
    String getName();

    void setName(String name);

    String getLast();

    void setLast(String last);

    Map<String, Object> getAdditionalProperties();

    void setAdditionalProperties(String key, Object value);
  }

  public static class ChildTypeImpl implements ChildType {
    private String name;

    private String last;

    private Map<String, Object> additionalProperties = new ExcludingMap();

    public String getName() {
      return this.name;
    }

    public void setName(String name) {
      this.name = name;
    }

    public String getLast() {
      return this.last;
    }

    public void setLast(String last) {
      this.last = last;
    }

    public Map<String, Object> getAdditionalProperties() {
      return additionalProperties;
    }

    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
  }
}
