package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(
    using = NilString.Deserializer.class
)
@JsonSerialize(
    using = NilString.Serializer.class
)
public class NilStringImpl implements NilString {
  private NilString.UnionType unionType;

  private String stringValue;

  protected NilStringImpl() {
  }

  public NilStringImpl(Object value) {
    if (value == null) {
      this.unionType = NilString.UnionType.NIL;
    }
    else if (value instanceof String) {
      this.unionType = NilString.UnionType.STRING;
      this.stringValue = (String) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public NilString.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == NilString.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isString() {
    return this.unionType == NilString.UnionType.STRING;
  }

  public String getString() {
    if (!isString()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.String");
    return this.stringValue;
  }
}
