package foo.foo;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonDeserialize(
    using = NilUnionTypeJ1.NilUnionTypeJ1Deserializer.class
)
@JsonSerialize(
    using = NilUnionTypeJ1.Serializer.class
)
public class NilUnionTypeJ1Impl implements NilUnionTypeJ1 {
  private NilUnionTypeJ1.UnionType unionType;

  private String stringValue;

  protected NilUnionTypeJ1Impl() {
  }

  public NilUnionTypeJ1Impl(Object value) {
    if (value == null) {
      this.unionType = NilUnionTypeJ1.UnionType.NIL;
    }
    else if (value instanceof String) {
      this.unionType = NilUnionTypeJ1.UnionType.STRING;
      this.stringValue = (String) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public NilUnionTypeJ1.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == NilUnionTypeJ1.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isString() {
    return this.unionType == NilUnionTypeJ1.UnionType.STRING;
  }

  public String getString() {
    if (!isString()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.String");
    return this.stringValue;
  }
}
