package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(
    using = SomeScalar.Deserializer.class
)
@JsonSerialize(
    using = SomeScalar.Serializer.class
)
public class SomeScalarImpl implements SomeScalar {
  private SomeScalar.UnionType unionType;

  private Integer integerValue;

  private String stringValue;

  protected SomeScalarImpl() {
  }

  public SomeScalarImpl(Object value) {
    if (value instanceof Integer) {
      this.unionType = SomeScalar.UnionType.INTEGER;
      this.integerValue = (Integer) value;
    }
    else if (value instanceof String) {
      this.unionType = SomeScalar.UnionType.STRING;
      this.stringValue = (String) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public SomeScalar.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isInteger() {
    return this.unionType == SomeScalar.UnionType.INTEGER;
  }

  public Integer getInteger() {
    if (!isInteger()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Integer");
    return this.integerValue;
  }

  public boolean isString() {
    return this.unionType == SomeScalar.UnionType.STRING;
  }

  public String getString() {
    if (!isString()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.String");
    return this.stringValue;
  }
}
