package foo.foo;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonDeserialize(
    using = SomeScalarJ1.SomeScalarJ1Deserializer.class
)
@JsonSerialize(
    using = SomeScalarJ1.Serializer.class
)
public class SomeScalarJ1Impl implements SomeScalarJ1 {
  private SomeScalarJ1.UnionType unionType;

  private Integer integerValue;

  private String stringValue;

  protected SomeScalarJ1Impl() {
  }

  public SomeScalarJ1Impl(Object value) {
    if (value instanceof Integer) {
      this.unionType = SomeScalarJ1.UnionType.INTEGER;
      this.integerValue = (Integer) value;
    }
    else if (value instanceof String) {
      this.unionType = SomeScalarJ1.UnionType.STRING;
      this.stringValue = (String) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public SomeScalarJ1.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isInteger() {
    return this.unionType == SomeScalarJ1.UnionType.INTEGER;
  }

  public Integer getInteger() {
    if (!isInteger()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Integer");
    return this.integerValue;
  }

  public boolean isString() {
    return this.unionType == SomeScalarJ1.UnionType.STRING;
  }

  public String getString() {
    if (!isString()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.String");
    return this.stringValue;
  }
}
