package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "goo",
    "declared"
})
public class UnionPropertyImpl implements UnionProperty {
  @JsonProperty("goo")
  private NilString goo;

  @JsonProperty("declared")
  private NilUnionType declared;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("goo")
  public NilString getGoo() {
    return this.goo;
  }

  @JsonProperty("goo")
  public void setGoo(NilString goo) {
    this.goo = goo;
  }

  @JsonProperty("declared")
  public NilUnionType getDeclared() {
    return this.declared;
  }

  @JsonProperty("declared")
  public void setDeclared(NilUnionType declared) {
    this.declared = declared;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }
}
