/*
 * Decompiled with CFR 0.152.
 */
package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import foo.foo.Date2UnionImpl;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public interface Date2Union {
    public UnionType getUnionType();

    public boolean isDate();

    public java.util.Date getDate();

    public boolean isNil();

    public Object getNil();

    public static enum UnionType {
        DATE,
        NIL;

    }

    public static class Deserializer
    extends StdDeserializer<Date2Union> {
        private static final long serialVersionUID = 1L;

        public Deserializer() {
            super(Date2Union.class);
        }

        public Date2Union getNullValue(DeserializationContext deserializationContext) {
            return new Date2UnionImpl(null);
        }

        private boolean isValidDate(String value, DateFormat format) {
            try {
                return format.parse(value) != null;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public Date2Union deserialize(JsonParser jp, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isNull()) {
                return new Date2UnionImpl(null);
            }
            if (node.isTextual() && this.isValidDate(node.asText(), new SimpleDateFormat("hh:mm:ss"))) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.setDateFormat((DateFormat)new SimpleDateFormat("hh:mm:ss"));
                return new Date2UnionImpl(mapper.treeToValue((TreeNode)node, Date.class));
            }
            throw new IOException("Can't figure out type of object " + node);
        }
    }

    public static class Serializer
    extends StdSerializer<Date2Union> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            super(Date2Union.class);
        }

        public void serialize(Date2Union object, JsonGenerator jsonGenerator, SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
            if (object.isDate()) {
                new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("hh:mm:ss")).writeValue(jsonGenerator, (Object)object.getDate());
                return;
            }
            if (object.isNil()) {
                jsonGenerator.writeObject(object.getNil());
                return;
            }
            throw new IOException("Can't figure out type of object" + object);
        }
    }
}

