/*
 * Decompiled with CFR 0.152.
 */
package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import foo.foo.NilUnionTypeImpl;
import java.io.IOException;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public interface NilUnionType {
    public UnionType getUnionType();

    public boolean isString();

    public String getString();

    public boolean isNil();

    public Object getNil();

    public static enum UnionType {
        STRING,
        NIL;

    }

    public static class Deserializer
    extends StdDeserializer<NilUnionType> {
        private static final long serialVersionUID = 1L;

        public Deserializer() {
            super(NilUnionType.class);
        }

        public NilUnionType getNullValue(DeserializationContext deserializationContext) {
            return new NilUnionTypeImpl(null);
        }

        public NilUnionType deserialize(JsonParser jp, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isNull()) {
                return new NilUnionTypeImpl(null);
            }
            if (node.isTextual()) {
                return new NilUnionTypeImpl(node.asText());
            }
            throw new IOException("Can't figure out type of object " + node);
        }
    }

    public static class Serializer
    extends StdSerializer<NilUnionType> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            super(NilUnionType.class);
        }

        public void serialize(NilUnionType object, JsonGenerator jsonGenerator, SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
            if (object.isString()) {
                jsonGenerator.writeObject((Object)object.getString());
                return;
            }
            if (object.isNil()) {
                jsonGenerator.writeObject(object.getNil());
                return;
            }
            throw new IOException("Can't figure out type of object" + object);
        }
    }
}

