package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "kind"
)
@JsonSubTypes({
    @JsonSubTypes.Type(foo.foo.Ocean.class),
    @JsonSubTypes.Type(foo.foo.Jungle.class),
    @JsonSubTypes.Type(foo.foo.BiomeBase.class)
})
@JsonDeserialize(
    as = BiomeBaseImpl.class
)
public interface BiomeBase {
  String _DISCRIMINATOR_TYPE_NAME = "BiomeBase";

  @JsonProperty("id")
  int getId();

  @JsonProperty("id")
  void setId(int id);

  @JsonProperty("name")
  String getName();

  @JsonProperty("name")
  void setName(String name);

  @JsonProperty("kind")
  String getKind();

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);
}
