package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(
    using = ComplexUnion.Deserializer.class
)
@JsonSerialize(
    using = ComplexUnion.Serializer.class
)
public class ComplexUnionImpl implements ComplexUnion {
  private ComplexUnion.UnionType unionType;

  private Boolean booleanValue;

  private Integer integerValue;

  private String stringValue;

  protected ComplexUnionImpl() {
  }

  public ComplexUnionImpl(Object value) {
    if (value == null) {
      this.unionType = ComplexUnion.UnionType.NIL;
    }
    else if (value instanceof Boolean) {
      this.unionType = ComplexUnion.UnionType.BOOLEAN;
      this.booleanValue = (Boolean) value;
    }
    else if (value instanceof Integer) {
      this.unionType = ComplexUnion.UnionType.INTEGER;
      this.integerValue = (Integer) value;
    }
    else if (value instanceof String) {
      this.unionType = ComplexUnion.UnionType.STRING;
      this.stringValue = (String) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public ComplexUnion.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == ComplexUnion.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isBoolean() {
    return this.unionType == ComplexUnion.UnionType.BOOLEAN;
  }

  public Boolean getBoolean() {
    if (!isBoolean()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Boolean");
    return this.booleanValue;
  }

  public boolean isInteger() {
    return this.unionType == ComplexUnion.UnionType.INTEGER;
  }

  public Integer getInteger() {
    if (!isInteger()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Integer");
    return this.integerValue;
  }

  public boolean isString() {
    return this.unionType == ComplexUnion.UnionType.STRING;
  }

  public String getString() {
    if (!isString()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.String");
    return this.stringValue;
  }
}
