package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;

@JsonDeserialize(
    using = Date1Union.Deserializer.class
)
@JsonSerialize(
    using = Date1Union.Serializer.class
)
public class Date1UnionImpl implements Date1Union {
  private Date1Union.UnionType unionType;

  private Date dateValue;

  protected Date1UnionImpl() {
  }

  public Date1UnionImpl(Object value) {
    if (value == null) {
      this.unionType = Date1Union.UnionType.NIL;
    }
    else if (value instanceof Date) {
      this.unionType = Date1Union.UnionType.DATE;
      this.dateValue = (Date) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public Date1Union.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == Date1Union.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isDate() {
    return this.unionType == Date1Union.UnionType.DATE;
  }

  public Date getDate() {
    if (!isDate()) throw new IllegalStateException("fetching wrong type out of the union: java.util.Date");
    return this.dateValue;
  }
}
