package foo.foo;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonDeserialize(
    using = Date1UnionJ1.Date1UnionJ1Deserializer.class
)
@JsonSerialize(
    using = Date1UnionJ1.Serializer.class
)
public interface Date1UnionJ1 {
  UnionType getUnionType();

  boolean isDate();

  Date getDate();

  boolean isNil();

  Object getNil();

  class Serializer extends SerializerBase<Date1UnionJ1> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Date1UnionJ1.class);
    }

    public void serialize(Date1UnionJ1 object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isDate()) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat(new SimpleDateFormat("yyyy-mm-dd"));
        objectMapper.writeValue(jsonGenerator, object.getDate());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Date1UnionJ1Deserializer extends StdDeserializer<Date1UnionJ1> {
    private static final long serialVersionUID = 1L;

    public Date1UnionJ1Deserializer() {
      super(Date1UnionJ1.class);}

    public Date1UnionJ1 getNullValue() {
      return new Date1UnionJ1Impl(null);
    }

    private boolean isValidDate(String value, DateFormat format) {
      try {
        return format.parse(value) != null;
      }
      catch (ParseException e) {
        return false;
      }
    }

    public Date1UnionJ1 deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new Date1UnionJ1Impl(null);
      }
      if (node.isTextual() && isValidDate(node.asText(), new SimpleDateFormat("yyyy-mm-dd"))) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(new SimpleDateFormat("yyyy-mm-dd"));
        return new Date1UnionJ1Impl(mapper.treeToValue(node, java.sql.Date.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    DATE,

    NIL
  }
}
