package foo.foo;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonDeserialize(
    using = Date3UnionJ1.Date3UnionJ1Deserializer.class
)
@JsonSerialize(
    using = Date3UnionJ1.Serializer.class
)
public interface Date3UnionJ1 {
  UnionType getUnionType();

  boolean isDate();

  Date getDate();

  boolean isNil();

  Object getNil();

  class Serializer extends SerializerBase<Date3UnionJ1> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Date3UnionJ1.class);
    }

    public void serialize(Date3UnionJ1 object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isDate()) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        objectMapper.writeValue(jsonGenerator, object.getDate());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Date3UnionJ1Deserializer extends StdDeserializer<Date3UnionJ1> {
    private static final long serialVersionUID = 1L;

    public Date3UnionJ1Deserializer() {
      super(Date3UnionJ1.class);}

    public Date3UnionJ1 getNullValue() {
      return new Date3UnionJ1Impl(null);
    }

    private boolean isValidDate(String value, DateFormat format) {
      try {
        return format.parse(value) != null;
      }
      catch (ParseException e) {
        return false;
      }
    }

    public Date3UnionJ1 deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new Date3UnionJ1Impl(null);
      }
      if (node.isTextual() && isValidDate(node.asText(), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"))) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        return new Date3UnionJ1Impl(mapper.treeToValue(node, java.sql.Date.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    DATE,

    NIL
  }
}
