package foo.foo;

import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonDeserialize(
    using = Date3UnionJ1.Date3UnionJ1Deserializer.class
)
@JsonSerialize(
    using = Date3UnionJ1.Serializer.class
)
public class Date3UnionJ1Impl implements Date3UnionJ1 {
  private Date3UnionJ1.UnionType unionType;

  private Date dateValue;

  protected Date3UnionJ1Impl() {
  }

  public Date3UnionJ1Impl(Object value) {
    if (value == null) {
      this.unionType = Date3UnionJ1.UnionType.NIL;
    }
    else if (value instanceof Date) {
      this.unionType = Date3UnionJ1.UnionType.DATE;
      this.dateValue = (Date) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public Date3UnionJ1.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isNil() {
    return this.unionType == Date3UnionJ1.UnionType.NIL;
  }

  public Object getNil() {
    if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
    return null;
  }

  public boolean isDate() {
    return this.unionType == Date3UnionJ1.UnionType.DATE;
  }

  public Date getDate() {
    if (!isDate()) throw new IllegalStateException("fetching wrong type out of the union: java.util.Date");
    return this.dateValue;
  }
}
