package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bark",
    "color"
})
public class DogImpl implements Dog {
  @JsonProperty("bark")
  private Dog.NilBooleanUnion bark;

  @JsonProperty("color")
  private String color;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("bark")
  public Dog.NilBooleanUnion getBark() {
    return this.bark;
  }

  @JsonProperty("bark")
  public void setBark(Dog.NilBooleanUnion bark) {
    this.bark = bark;
  }

  @JsonProperty("color")
  public String getColor() {
    return this.color;
  }

  @JsonProperty("color")
  public void setColor(String color) {
    this.color = color;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  public static class NilBooleanUnionImpl implements Dog.NilBooleanUnion {
    private Dog.NilBooleanUnion.UnionType unionType;

    private Boolean booleanValue;

    protected NilBooleanUnionImpl() {
    }

    public NilBooleanUnionImpl(Object value) {
      if (value == null) {
        this.unionType = Dog.NilBooleanUnion.UnionType.NIL;
      }
      else if (value instanceof Boolean) {
        this.unionType = Dog.NilBooleanUnion.UnionType.BOOLEAN;
        this.booleanValue = (Boolean) value;
      }
      else {
        throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
      }
    }

    public Dog.NilBooleanUnion.UnionType getUnionType() {
      return this.unionType;
    }

    public boolean isNil() {
      return this.unionType == Dog.NilBooleanUnion.UnionType.NIL;
    }

    public Object getNil() {
      if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
      return null;
    }

    public boolean isBoolean() {
      return this.unionType == Dog.NilBooleanUnion.UnionType.BOOLEAN;
    }

    public Boolean getBoolean() {
      if (!isBoolean()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Boolean");
      return this.booleanValue;
    }
  }
}
