package foo.foo;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bark",
    "color"
})
public class DogJ1Impl implements DogJ1 {
  @JsonProperty("bark")
  private DogJ1.NilBooleanUnion bark;

  @JsonProperty("color")
  private String color;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("bark")
  public DogJ1.NilBooleanUnion getBark() {
    return this.bark;
  }

  @JsonProperty("bark")
  public void setBark(DogJ1.NilBooleanUnion bark) {
    this.bark = bark;
  }

  @JsonProperty("color")
  public String getColor() {
    return this.color;
  }

  @JsonProperty("color")
  public void setColor(String color) {
    this.color = color;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  public static class NilBooleanUnionImpl implements DogJ1.NilBooleanUnion {
    private DogJ1.NilBooleanUnion.UnionType unionType;

    private Boolean booleanValue;

    protected NilBooleanUnionImpl() {
    }

    public NilBooleanUnionImpl(Object value) {
      if (value == null) {
        this.unionType = DogJ1.NilBooleanUnion.UnionType.NIL;
      }
      else if (value instanceof Boolean) {
        this.unionType = DogJ1.NilBooleanUnion.UnionType.BOOLEAN;
        this.booleanValue = (Boolean) value;
      }
      else {
        throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
      }
    }

    public DogJ1.NilBooleanUnion.UnionType getUnionType() {
      return this.unionType;
    }

    public boolean isNil() {
      return this.unionType == DogJ1.NilBooleanUnion.UnionType.NIL;
    }

    public Object getNil() {
      if (!isNil()) throw new IllegalStateException("fetching wrong type out of the union: NullType should be null");
      return null;
    }

    public boolean isBoolean() {
      return this.unionType == DogJ1.NilBooleanUnion.UnionType.BOOLEAN;
    }

    public Boolean getBoolean() {
      if (!isBoolean()) throw new IllegalStateException("fetching wrong type out of the union: java.lang.Boolean");
      return this.booleanValue;
    }
  }
}
