package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@JsonDeserialize(
    using = Entertainement.Deserializer.class
)
@JsonSerialize(
    using = Entertainement.Serializer.class
)
public interface Entertainement {
  UnionType getUnionType();

  boolean isTelevision();

  Television getTelevision();

  boolean isProjector();

  Projector getProjector();

  class Serializer extends StdSerializer<Entertainement> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(Entertainement.class);
    }

    public void serialize(Entertainement object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isTelevision()) {
        jsonGenerator.writeObject(object.getTelevision());
        return;
      }
      if ( object.isProjector()) {
        jsonGenerator.writeObject(object.getProjector());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<Entertainement> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(Entertainement.class);
    }

    private boolean isValidObject(JsonNode node, List<String> keys) {
      List<String> list = new ArrayList<>();
      Iterator<String> fieldIterator = node.fieldNames();
      while (fieldIterator.hasNext()) { list.add(fieldIterator.next()); };
      return list.containsAll(keys);
    }

    public Entertainement deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isObject() && isValidObject(node, Arrays.asList("hanging"))) {
        return new EntertainementImpl(jp.getCodec().treeToValue(node, Projector.class));
      }
      if (node.isObject() && isValidObject(node, Arrays.asList("color"))) {
        return new EntertainementImpl(jp.getCodec().treeToValue(node, Television.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    TELEVISION,

    PROJECTOR
  }
}
