package foo.foo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonDeserialize(
    using = Entertainement.Deserializer.class
)
@JsonSerialize(
    using = Entertainement.Serializer.class
)
public class EntertainementImpl implements Entertainement {
  private Entertainement.UnionType unionType;

  private Projector projectorValue;

  private Television televisionValue;

  protected EntertainementImpl() {
  }

  public EntertainementImpl(Object value) {
    if (value instanceof Projector) {
      this.unionType = Entertainement.UnionType.PROJECTOR;
      this.projectorValue = (Projector) value;
    }
    else if (value instanceof Television) {
      this.unionType = Entertainement.UnionType.TELEVISION;
      this.televisionValue = (Television) value;
    }
    else {
      throw new IllegalArgumentException("Union creation is not supported for given value: " + value);
    }
  }

  public Entertainement.UnionType getUnionType() {
    return this.unionType;
  }

  public boolean isProjector() {
    return this.unionType == Entertainement.UnionType.PROJECTOR;
  }

  public Projector getProjector() {
    if (!isProjector()) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.Projector");
    return this.projectorValue;
  }

  public boolean isTelevision() {
    return this.unionType == Entertainement.UnionType.TELEVISION;
  }

  public Television getTelevision() {
    if (!isTelevision()) throw new IllegalStateException("fetching wrong type out of the union: foo.foo.Television");
    return this.televisionValue;
  }
}
