package foo.foo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonDeserialize(
    using = EntertainementJ1.EntertainementJ1Deserializer.class
)
@JsonSerialize(
    using = EntertainementJ1.Serializer.class
)
public interface EntertainementJ1 {
  UnionType getUnionType();

  boolean isTelevisionJ1();

  TelevisionJ1 getTelevisionJ1();

  boolean isProjectorJ1();

  ProjectorJ1 getProjectorJ1();

  class Serializer extends SerializerBase<EntertainementJ1> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(EntertainementJ1.class);
    }

    public void serialize(EntertainementJ1 object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isTelevisionJ1()) {
        jsonGenerator.writeObject(object.getTelevisionJ1());
        return;
      }
      if ( object.isProjectorJ1()) {
        jsonGenerator.writeObject(object.getProjectorJ1());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class EntertainementJ1Deserializer extends StdDeserializer<EntertainementJ1> {
    private static final long serialVersionUID = 1L;

    public EntertainementJ1Deserializer() {
      super(EntertainementJ1.class);}

    private boolean isValidObject(JsonNode node, List<String> keys) {
      List<String> list = new ArrayList<>();
      Iterator<String> fieldIterator = node.getFieldNames();
      while (fieldIterator.hasNext()) { list.add(fieldIterator.next()); };
      return list.containsAll(keys);
    }

    public EntertainementJ1 deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isObject() && isValidObject(node, Arrays.asList("hanging"))) {
        return new EntertainementJ1Impl(jp.getCodec().treeToValue(node, ProjectorJ1.class));
      }
      if (node.isObject() && isValidObject(node, Arrays.asList("color"))) {
        return new EntertainementJ1Impl(jp.getCodec().treeToValue(node, TelevisionJ1.class));
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    TELEVISION_J1,

    PROJECTOR_J1
  }
}
