package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

@JsonDeserialize(
    using = NilString.Deserializer.class
)
@JsonSerialize(
    using = NilString.Serializer.class
)
public interface NilString {
  UnionType getUnionType();

  boolean isString();

  String getString();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<NilString> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(NilString.class);
    }

    public void serialize(NilString object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isString()) {
        jsonGenerator.writeObject(object.getString());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<NilString> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(NilString.class);
    }

    public NilString getNullValue(DeserializationContext deserializationContext) {
      return new NilStringImpl(null);
    }

    public NilString deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new NilStringImpl(null);
      }
      if (node.isTextual()) {
        return new NilStringImpl(node.asText());
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    STRING,

    NIL
  }
}
