package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

@JsonDeserialize(
    using = NilUnionType.Deserializer.class
)
@JsonSerialize(
    using = NilUnionType.Serializer.class
)
public interface NilUnionType {
  UnionType getUnionType();

  boolean isString();

  String getString();

  boolean isNil();

  Object getNil();

  class Serializer extends StdSerializer<NilUnionType> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(NilUnionType.class);
    }

    public void serialize(NilUnionType object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isString()) {
        jsonGenerator.writeObject(object.getString());
        return;
      }
      if ( object.isNil()) {
        jsonGenerator.writeObject(object.getNil());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<NilUnionType> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(NilUnionType.class);
    }

    public NilUnionType getNullValue(DeserializationContext deserializationContext) {
      return new NilUnionTypeImpl(null);
    }

    public NilUnionType deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isNull()) {
        return new NilUnionTypeImpl(null);
      }
      if (node.isTextual()) {
        return new NilUnionTypeImpl(node.asText());
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    STRING,

    NIL
  }
}
