package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

@JsonDeserialize(
    using = SomeScalar.Deserializer.class
)
@JsonSerialize(
    using = SomeScalar.Serializer.class
)
public interface SomeScalar {
  UnionType getUnionType();

  boolean isString();

  String getString();

  boolean isInteger();

  Integer getInteger();

  class Serializer extends StdSerializer<SomeScalar> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(SomeScalar.class);
    }

    public void serialize(SomeScalar object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isString()) {
        jsonGenerator.writeObject(object.getString());
        return;
      }
      if ( object.isInteger()) {
        jsonGenerator.writeObject(object.getInteger());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class Deserializer extends StdDeserializer<SomeScalar> {
    private static final long serialVersionUID = 1L;

    public Deserializer() {
      super(SomeScalar.class);
    }

    public SomeScalar deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isInt()) {
        return new SomeScalarImpl(node.asInt());
      }
      if (node.isTextual()) {
        return new SomeScalarImpl(node.asText());
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    STRING,

    INTEGER
  }
}
