package foo.foo;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonDeserialize(
    using = SomeScalarJ1.SomeScalarJ1Deserializer.class
)
@JsonSerialize(
    using = SomeScalarJ1.Serializer.class
)
public interface SomeScalarJ1 {
  UnionType getUnionType();

  boolean isString();

  String getString();

  boolean isInteger();

  Integer getInteger();

  class Serializer extends SerializerBase<SomeScalarJ1> {
    private static final long serialVersionUID = 1L;

    public Serializer() {
      super(SomeScalarJ1.class);
    }

    public void serialize(SomeScalarJ1 object, JsonGenerator jsonGenerator,
        SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
      if ( object.isString()) {
        jsonGenerator.writeObject(object.getString());
        return;
      }
      if ( object.isInteger()) {
        jsonGenerator.writeObject(object.getInteger());
        return;
      }
      throw new IOException("Can't figure out type of object" + object);
    }
  }

  class SomeScalarJ1Deserializer extends StdDeserializer<SomeScalarJ1> {
    private static final long serialVersionUID = 1L;

    public SomeScalarJ1Deserializer() {
      super(SomeScalarJ1.class);}

    public SomeScalarJ1 deserialize(JsonParser jp, DeserializationContext jsonContext) throws
        IOException, JsonProcessingException {
      JsonNode node = jp.getCodec().readTree(jp);
      if (node.isInt()) {
        return new SomeScalarJ1Impl(node.asInt());
      }
      if (node.isTextual()) {
        return new SomeScalarJ1Impl(node.asText());
      }
      throw new IOException("Can't figure out type of object " + node);
    }
  }

  enum UnionType {
    STRING,

    INTEGER
  }
}
