/*
 * Decompiled with CFR 0.152.
 */
package foo.foo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import foo.foo.BiomeBase;
import foo.foo.BiomeImpl;
import foo.foo.Jungle;
import foo.foo.Ocean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public interface Biome {
    public UnionType getUnionType();

    public boolean isOcean();

    public Ocean getOcean();

    public boolean isJungle();

    public Jungle getJungle();

    public static enum UnionType {
        OCEAN,
        JUNGLE;

    }

    public static class Deserializer
    extends StdDeserializer<Biome> {
        private static final long serialVersionUID = 1L;

        public Deserializer() {
            super(Biome.class);
        }

        private boolean isValidObject(JsonNode node, List<String> keys) {
            ArrayList list = new ArrayList();
            Iterator fieldIterator = node.fieldNames();
            while (fieldIterator.hasNext()) {
                list.add(fieldIterator.next());
            }
            return list.containsAll(keys);
        }

        public Biome deserialize(JsonParser jp, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isObject() && this.isValidObject(node, Arrays.asList("id", "name", "kind", "animals")) && Objects.equals(node.path("kind").asText(), "Ocean")) {
                return new BiomeImpl((Ocean)jp.getCodec().treeToValue((TreeNode)node, BiomeBase.class));
            }
            if (node.isObject() && this.isValidObject(node, Arrays.asList("id", "name", "kind", "animals")) && Objects.equals(node.path("kind").asText(), "Jungle")) {
                return new BiomeImpl((Jungle)jp.getCodec().treeToValue((TreeNode)node, BiomeBase.class));
            }
            throw new IOException("Can't figure out type of object " + node);
        }
    }

    public static class Serializer
    extends StdSerializer<Biome> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            super(Biome.class);
        }

        public void serialize(Biome object, JsonGenerator jsonGenerator, SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
            if (object.isOcean()) {
                jsonGenerator.writeObject((Object)object.getOcean());
                return;
            }
            if (object.isJungle()) {
                jsonGenerator.writeObject((Object)object.getJungle());
                return;
            }
            throw new IOException("Can't figure out type of object" + object);
        }
    }
}

