/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.plugin.maven;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.raml.ramltopojo.RamlToPojo;
import org.raml.ramltopojo.RamlToPojoBuilder;
import org.raml.ramltopojo.TypeFetchers;
import org.raml.ramltopojo.TypeFinders;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.api.Api;

@Mojo(name="generate", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RamlToPojoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/raml-to-jaxrs-maven-plugin")
    private File outputDirectory;
    @Parameter(property="ramlFile", required=true)
    private File ramlFile;
    @Parameter(property="defaultPackage", required=true)
    private String defaultPackage;
    @Parameter(property="defaultPackage", required=false)
    private List<String> basePlugins;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution...");
            return;
        }
        if (this.ramlFile == null) {
            throw new MojoExecutionException("ramlFile is not defined");
        }
        try {
            FileUtils.forceMkdir((File)this.outputDirectory);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to createHandler directory: " + this.outputDirectory, (Exception)ioe);
        }
        try {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
            this.getLog().info((CharSequence)("about to read file " + this.ramlFile + " in directory " + this.ramlFile.getParent()));
            RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi((Reader)new FileReader(this.ramlFile), this.ramlFile.getAbsolutePath());
            if (ramlModelResult.hasErrors()) {
                for (ValidationResult validationResult : ramlModelResult.getValidationResults()) {
                    this.getLog().error((CharSequence)("raml error:" + validationResult.getMessage()));
                }
                throw new MojoExecutionException("invalid raml " + this.ramlFile);
            }
            Api api = ramlModelResult.getApiV10();
            RamlToPojo ramlToPojo = RamlToPojoBuilder.builder((Api)api).inPackage(this.defaultPackage).fetchTypes(TypeFetchers.fromAnywhere()).findTypes(TypeFinders.everyWhere()).build(this.basePlugins);
            ramlToPojo.buildPojos().createAllTypes(this.outputDirectory.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("execution exception", (Exception)e);
        }
    }
}

