/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Optional;
import com.squareup.javapoet.TypeName;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContextImpl;
import org.raml.ramltopojo.RamlToPojo;
import org.raml.ramltopojo.ResultingPojos;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeFinder;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RamlToPojoImpl
implements RamlToPojo {
    private final TypeFinder typeFinder;
    private final GenerationContextImpl generationContext;

    public RamlToPojoImpl(TypeFinder typeFinder, GenerationContextImpl generationContext) {
        this.typeFinder = typeFinder;
        this.generationContext = generationContext;
    }

    @Override
    public ResultingPojos buildPojos() {
        ResultingPojos resultingPojos = new ResultingPojos(this.generationContext);
        for (TypeDeclaration typeDeclaration : this.typeFinder.findTypes(this.generationContext.api())) {
            TypeDeclarationType.calculateTypeName(typeDeclaration.name(), typeDeclaration, this.generationContext, EventType.INTERFACE);
        }
        for (TypeDeclaration typeDeclaration : this.typeFinder.findTypes(this.generationContext.api())) {
            Optional<CreationResult> spec = TypeDeclarationType.createType(typeDeclaration, this.generationContext);
            if (!spec.isPresent()) continue;
            resultingPojos.addNewResult((CreationResult)spec.get());
        }
        return resultingPojos;
    }

    @Override
    public ResultingPojos buildPojo(TypeDeclaration typeDeclaration) {
        ResultingPojos resultingPojos = new ResultingPojos(this.generationContext);
        Optional<CreationResult> spec = TypeDeclarationType.createType(typeDeclaration, this.generationContext);
        if (spec.isPresent()) {
            resultingPojos.addNewResult((CreationResult)spec.get());
        }
        return resultingPojos;
    }

    @Override
    public ResultingPojos buildPojo(String suggestedJavaName, TypeDeclaration typeDeclaration) {
        ResultingPojos resultingPojos = new ResultingPojos(this.generationContext);
        Optional<CreationResult> spec = TypeDeclarationType.createNamedType(suggestedJavaName, typeDeclaration, this.generationContext);
        if (spec.isPresent()) {
            resultingPojos.addNewResult((CreationResult)spec.get());
        }
        return resultingPojos;
    }

    @Override
    public TypeName fetchType(String suggestedName, TypeDeclaration typeDeclaration) {
        return TypeDeclarationType.calculateTypeName(suggestedName, typeDeclaration, this.generationContext, EventType.INTERFACE);
    }

    @Override
    public boolean isInline(TypeDeclaration typeDeclaration) {
        return TypeDeclarationType.isNewInlineType(typeDeclaration);
    }
}

