/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.tools;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.AllTypesPluginHelper;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class AddToString
extends AllTypesPluginHelper {
    private final List<String> arguments;

    public AddToString(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            ImmutableList specs = FluentIterable.from((Iterable)incoming.build().fieldSpecs).filter((Predicate)new Predicate<FieldSpec>(){

                public boolean apply(@Nullable FieldSpec input) {
                    if (AddToString.this.arguments.isEmpty()) {
                        return true;
                    }
                    return AddToString.this.arguments.contains(input.name);
                }
            }).toList();
            if (specs.isEmpty()) {
                return incoming;
            }
            this.createToString((List<FieldSpec>)specs, incoming);
            return incoming;
        }
        return super.classCreated(objectPluginContext, ramlType, incoming, eventType);
    }

    private void createToString(List<FieldSpec> fields, TypeSpec.Builder incoming) {
        String s = FluentIterable.from(fields).transform((Function)new Function<FieldSpec, String>(){

            @Nullable
            public String apply(@Nullable FieldSpec fieldSpec) {
                if (fieldSpec.type.isPrimitive() || fieldSpec.type.equals((Object)ClassName.get(String.class))) {
                    return CodeBlock.builder().add("$S + $T.toString(this.$L)", new Object[]{fieldSpec.name + " = ", Objects.class, fieldSpec.name}).build().toString();
                }
                return CodeBlock.builder().add("$S + $T.toString(this.$L) + \"]\"", new Object[]{fieldSpec.name + " = [", Objects.class, fieldSpec.name}).build().toString();
            }
        }).join(Joiner.on((String)" + \", \" + "));
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"toString").addAnnotation(ClassName.get(Override.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(String.class)).addCode(CodeBlock.builder().addStatement("return " + s, new Object[0]).build());
        incoming.addMethod(method.build());
    }

    @Override
    public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        if (eventType != EventType.IMPLEMENTATION) {
            return incoming;
        }
        List specs = incoming.build().fieldSpecs;
        this.createToString(specs, incoming);
        return incoming;
    }
}

