/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.ramltopojo.GenerationException;

public class PluginManager {
    public static PluginManager NULL = new PluginManager(null){

        @Override
        public <T> Set<T> getClassesForName(String name, List<String> arguments, Class<T> ofClass) {
            return Collections.emptySet();
        }
    };
    private SetMultimap<String, Class<?>> info;

    PluginManager(SetMultimap<String, Class<?>> info) {
        this.info = info;
    }

    public static PluginManager createPluginManager() {
        return PluginManager.createPluginManager("META-INF/ramltopojo-plugin.properties");
    }

    public static PluginManager createPluginManager(String pluginFileName) {
        try {
            LinkedHashMultimap info = LinkedHashMultimap.create();
            Enumeration<URL> resourcesFiles = PluginManager.class.getClassLoader().getResources(pluginFileName);
            while (resourcesFiles.hasMoreElements()) {
                URL url = resourcesFiles.nextElement();
                Properties properties = new Properties();
                PluginManager.loadProperties(url, properties);
                PluginManager.buildPluginNames(info, properties);
            }
            return new PluginManager((SetMultimap<String, Class<?>>)info);
        }
        catch (IOException e) {
            throw new GenerationException(e);
        }
    }

    public <T> Set<T> getClassesForName(String name, final @Nonnull List<String> arguments, final Class<T> ofClass) {
        ImmutableSet plugins = FluentIterable.from((Iterable)this.info.get((Object)name)).filter(new Predicate<Class<?>>(){

            public boolean apply(@Nullable Class<?> input) {
                return ofClass.isAssignableFrom(input);
            }
        }).transform(new Function<Class, T>(){

            @Nullable
            public T apply(@Nullable Class input) {
                try {
                    try {
                        Constructor constructor = input.getConstructor(List.class);
                        return constructor.newInstance(arguments);
                    }
                    catch (NoSuchMethodException | InvocationTargetException e) {
                        return input.newInstance();
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new GenerationException(e);
                }
            }
        }).toSet();
        return plugins;
    }

    private static void buildPluginNames(SetMultimap<String, Class<?>> info, Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            List<Class<?>> classList = PluginManager.classList(name, properties.getProperty(name));
            if (info.containsKey((Object)name)) {
                throw new GenerationException("duplicate name in plugins: " + name);
            }
            info.putAll((Object)name, classList);
        }
    }

    private static List<Class<?>> classList(String name, String property) {
        ArrayList classes = new ArrayList();
        for (String s : property.split("\\s*,\\s*")) {
            try {
                Class<?> foundClass = Class.forName(s);
                classes.add(foundClass);
            }
            catch (ClassNotFoundException e) {
                throw new GenerationException("class " + s + " not found for plugin name " + name);
            }
        }
        return classes;
    }

    private static void loadProperties(URL url, Properties p) {
        try {
            p.load(url.openStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

