/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.TypeFetcher;
import org.raml.ramltopojo.Utils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class TypeFetchers {
    public static final TypeFetcher NULL_FETCHER = new TypeFetcher(){

        @Override
        public TypeDeclaration fetchType(Api api, String name) throws GenerationException {
            throw new GenerationException("null fetcher can't fetch types: " + name);
        }
    };

    public static TypeFetcher fromTypes() {
        return new TypeFetcher(){
            Iterable<TypeDeclaration> foundInApi;

            @Override
            public TypeDeclaration fetchType(Api api, String name) throws GenerationException {
                return (TypeDeclaration)FluentIterable.from((Iterable)((Iterable)Optional.fromNullable(this.foundInApi).or((Object)api.types()))).firstMatch(TypeFetchers.namedPredicate(name)).or(TypeFetchers.fail(name));
            }
        };
    }

    protected static Supplier<TypeDeclaration> fail(final String name) {
        return new Supplier<TypeDeclaration>(){

            public TypeDeclaration get() {
                throw new GenerationException("can't fetch type named " + name);
            }
        };
    }

    public static TypeFetcher fromLibraries() {
        return new TypeFetcher(){
            Iterable<TypeDeclaration> foundInApi;

            @Override
            public TypeDeclaration fetchType(Api api, String name) throws GenerationException {
                return (TypeDeclaration)FluentIterable.from((Iterable)((Iterable)Optional.fromNullable(this.foundInApi).or(Utils.goThroughLibraries(new ArrayList<TypeDeclaration>(), new HashSet<String>(), api.uses())))).firstMatch(TypeFetchers.namedPredicate(name)).or(TypeFetchers.fail(name));
            }
        };
    }

    public static TypeFetcher fromAnywhere() {
        return new TypeFetcher(){
            Iterable<TypeDeclaration> foundInApi;

            @Override
            public TypeDeclaration fetchType(Api api, String name) throws GenerationException {
                return (TypeDeclaration)FluentIterable.from((Iterable)((Iterable)Optional.fromNullable(this.foundInApi).or((Object)FluentIterable.from((Iterable)api.types()).append(Utils.goThroughLibraries(new ArrayList<TypeDeclaration>(), new HashSet<String>(), api.uses()))))).firstMatch(TypeFetchers.namedPredicate(name)).or(TypeFetchers.fail(name));
            }
        };
    }

    protected static Predicate<TypeDeclaration> namedPredicate(final String name) {
        return new Predicate<TypeDeclaration>(){

            public boolean apply(@Nullable TypeDeclaration input) {
                return name.equals(input.name());
            }
        };
    }
}

