/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.union;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.ramltopojo.extensions.UnionPluginContextImpl;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionTypeHandler
implements TypeHandler {
    private final String name;
    private final UnionTypeDeclaration union;

    public UnionTypeHandler(String name, UnionTypeDeclaration union) {
        this.name = name;
        this.union = union;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        UnionPluginContextImpl context = new UnionPluginContextImpl(generationContext, null);
        UnionTypeHandlerPlugin plugin = generationContext.pluginsForUnions(Utils.allParents((TypeDeclaration)this.union, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0]));
        ClassName className = type == EventType.IMPLEMENTATION ? generationContext.buildDefaultClassName(Names.typeName(this.name, "Impl"), EventType.IMPLEMENTATION) : generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE);
        return plugin.className(context, this.union, className, type);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult preCreationResult) {
        UnionPluginContextImpl context = new UnionPluginContextImpl(generationContext, preCreationResult);
        ClassName interfaceName = preCreationResult.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder interf = this.getDeclaration(generationContext, context, preCreationResult);
        TypeSpec.Builder impl = this.getImplementation(interfaceName, generationContext, context, preCreationResult);
        if (interf == null) {
            return Optional.absent();
        }
        return Optional.of((Object)preCreationResult.withInterface(interf.build()).withImplementation(impl.build()));
    }

    private TypeSpec.Builder getImplementation(ClassName interfaceName, GenerationContext generationContext, UnionPluginContext context, CreationResult preCreationResult) {
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)preCreationResult.getJavaName(EventType.IMPLEMENTATION)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)interfaceName);
        FieldSpec.Builder anyType = FieldSpec.builder(Object.class, (String)"anyType", (Modifier[])new Modifier[]{Modifier.PRIVATE});
        anyType = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).anyFieldCreated(context, this.union, typeSpec, anyType, EventType.IMPLEMENTATION);
        if (anyType == null) {
            return typeSpec;
        }
        typeSpec.addField(anyType.build());
        typeSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("this.anyType = null", new Object[0]).build());
        for (TypeDeclaration unitedType : this.union.of()) {
            TypeName typeName = this.findType(unitedType.name(), unitedType, generationContext).box();
            String shortened = this.shorten(typeName);
            String fieldName = Names.methodName(unitedType.name());
            typeSpec.addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.anyType = $L", new Object[]{fieldName}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", shortened)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName).addStatement("if ( !(anyType instanceof  $T)) throw new $T(\"fetching wrong type out of the union: $L\")", new Object[]{typeName, IllegalStateException.class, typeName}).addStatement("return ($T) anyType", new Object[]{typeName}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("is", shortened)).addStatement("return anyType instanceof $T", new Object[]{typeName}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).build()).build();
        }
        typeSpec = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).classCreated(context, this.union, typeSpec, EventType.IMPLEMENTATION);
        if (typeSpec == null) {
            return null;
        }
        return typeSpec;
    }

    private TypeSpec.Builder getDeclaration(final GenerationContext generationContext, UnionPluginContext context, CreationResult preCreationResult) {
        TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((ClassName)preCreationResult.getJavaName(EventType.INTERFACE)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ImmutableList names = FluentIterable.from((Iterable)this.union.of()).transform((Function)new Function<TypeDeclaration, TypeName>(){

            @Nullable
            public TypeName apply(@Nullable TypeDeclaration unitedType) {
                return UnionTypeHandler.this.findType(unitedType.name(), unitedType, generationContext).box();
            }
        }).toList();
        typeSpec = generationContext.pluginsForUnions(new TypeDeclaration[]{this.union}).classCreated(context, this.union, typeSpec, EventType.INTERFACE);
        if (typeSpec == null) {
            return null;
        }
        for (TypeName unitedType : names) {
            if (unitedType instanceof ArrayTypeDeclaration) {
                throw new GenerationException("ramltopojo currently does not support arrays in unions");
            }
            String shortened = this.shorten(unitedType);
            typeSpec.addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", shortened)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(unitedType).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("is", shortened)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TypeName.BOOLEAN).build());
        }
        return typeSpec;
    }

    private String shorten(TypeName typeName) {
        if (!(typeName instanceof ClassName)) {
            throw new GenerationException(typeName + this.toString() + " cannot be shortened reasonably");
        }
        return ((ClassName)typeName).simpleName();
    }

    private TypeName findType(String typeName, TypeDeclaration type, GenerationContext generationContext) {
        return TypeDeclarationType.calculateTypeName(typeName, type, generationContext, EventType.INTERFACE);
    }
}

