/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.raml.ramltopojo.Annotations;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.PluginDef;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeFetcher;
import org.raml.ramltopojo.TypeFetchers;
import org.raml.ramltopojo.extensions.ArrayTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.EnumerationTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.ReferenceTypeHandlerPlugin;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.ramltopojo.plugin.PluginManager;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class GenerationContextImpl
implements GenerationContext {
    private final PluginManager pluginManager;
    private final Api api;
    private final TypeFetcher typeFetcher;
    private final ConcurrentHashMap<String, CreationResult> knownTypes = new ConcurrentHashMap();
    private final SetMultimap<String, String> childTypes = HashMultimap.create();
    private final String defaultPackage;
    private final List<String> basePlugins;
    private Map<String, TypeSpec> supportClasses = new HashMap<String, TypeSpec>();

    public GenerationContextImpl(Api api) {
        this(PluginManager.NULL, api, TypeFetchers.NULL_FETCHER, "", Collections.emptyList());
    }

    public GenerationContextImpl(PluginManager pluginManager, Api api, TypeFetcher typeFetcher, String defaultPackage, List<String> basePlugins) {
        this.pluginManager = pluginManager;
        this.api = api;
        this.typeFetcher = typeFetcher;
        this.defaultPackage = defaultPackage;
        this.basePlugins = basePlugins;
    }

    @Override
    public CreationResult findCreatedType(String typeName, TypeDeclaration ramlType) {
        if (this.knownTypes.containsKey(typeName)) {
            return this.knownTypes.get(typeName);
        }
        TypeDeclaration typeDeclaration = this.typeFetcher.fetchType(this.api, typeName);
        Optional<CreationResult> result = TypeDeclarationType.createType(typeDeclaration, this);
        if (result.isPresent()) {
            this.knownTypes.put(typeName, (CreationResult)result.get());
            return (CreationResult)result.get();
        }
        return null;
    }

    @Override
    public String defaultPackage() {
        return this.defaultPackage;
    }

    @Override
    public Set<String> childClasses(String ramlTypeName) {
        return this.childTypes.get((Object)ramlTypeName);
    }

    @Override
    public ClassName buildDefaultClassName(String name, EventType eventType) {
        return ClassName.get((String)this.defaultPackage, (String)name, (String[])new String[0]);
    }

    @Override
    public void setupTypeHierarchy(TypeDeclaration typeDeclaration) {
        List parents = typeDeclaration.parentTypes();
        for (TypeDeclaration parent : parents) {
            this.setupTypeHierarchy(parent);
            this.childTypes.put((Object)parent.name(), (Object)typeDeclaration.name());
        }
    }

    @Override
    public void newExpectedType(String name, CreationResult creationResult) {
        this.knownTypes.put(name, creationResult);
    }

    @Override
    public void createTypes(String rootDirectory) throws IOException {
        for (CreationResult creationResult : this.knownTypes.values()) {
            creationResult.createType(rootDirectory);
        }
    }

    @Override
    public void createSupportTypes(String rootDirectory) throws IOException {
        for (TypeSpec typeSpec : this.supportClasses.values()) {
            JavaFile.builder((String)this.defaultPackage(), (TypeSpec)typeSpec).build().writeTo(Paths.get(rootDirectory, new String[0]));
        }
    }

    private <T> void loadBasePlugins(Set<T> plugins, Class<T> pluginType, TypeDeclaration ... typeDeclarations) {
        for (TypeDeclaration typeDeclaration : typeDeclarations) {
            if (Annotations.CLASS_NAME.get((Annotable)typeDeclaration) != null) {
                this.pluginManager.getClassesForName("core.rename", Collections.singletonList(Annotations.CLASS_NAME.get((Annotable)typeDeclaration)), pluginType);
            }
            if (Annotations.IMPLEMENTATION_CLASS_NAME.get((Annotable)typeDeclaration) != null) {
                this.pluginManager.getClassesForName("core.renameImplementation", Collections.singletonList(Annotations.IMPLEMENTATION_CLASS_NAME.get((Annotable)typeDeclaration)), pluginType);
            }
            if (!Annotations.USE_PRIMITIVE.get((Annotable)typeDeclaration).booleanValue()) {
                this.pluginManager.getClassesForName("core.box", Collections.emptyList(), pluginType);
            }
            if (Annotations.ABSTRACT.get((Annotable)typeDeclaration).booleanValue()) continue;
            this.pluginManager.getClassesForName("core.makeAbstract", Collections.emptyList(), pluginType);
        }
        for (String basePlugin : this.basePlugins) {
            plugins.addAll(this.pluginManager.getClassesForName(basePlugin, Collections.emptyList(), pluginType));
        }
    }

    @Override
    public TypeName createSupportClass(TypeSpec.Builder newSupportType) {
        TypeSpec typeSpec = newSupportType.build();
        if (this.supportClasses.containsKey(typeSpec.name)) {
            TypeSpec builder = this.supportClasses.get(typeSpec.name);
            return ClassName.get((String)this.defaultPackage, (String)builder.name, (String[])new String[0]);
        }
        this.supportClasses.put(typeSpec.name, typeSpec);
        return ClassName.get((String)this.defaultPackage, (String)typeSpec.name, (String[])new String[0]);
    }

    @Override
    public ObjectTypeHandlerPlugin pluginsForObjects(TypeDeclaration ... typeDeclarations) {
        List data = Annotations.PLUGINS.get(Collections.emptyList(), (Annotable)this.api, (Annotable[])typeDeclarations);
        HashSet<ObjectTypeHandlerPlugin> plugins = new HashSet<ObjectTypeHandlerPlugin>();
        this.loadBasePlugins(plugins, ObjectTypeHandlerPlugin.class, new TypeDeclaration[0]);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), ObjectTypeHandlerPlugin.class));
        }
        return new ObjectTypeHandlerPlugin.Composite(plugins);
    }

    @Override
    public EnumerationTypeHandlerPlugin pluginsForEnumerations(TypeDeclaration ... typeDeclarations) {
        List data = Annotations.PLUGINS.get(Collections.emptyList(), (Annotable)this.api, (Annotable[])typeDeclarations);
        HashSet<EnumerationTypeHandlerPlugin> plugins = new HashSet<EnumerationTypeHandlerPlugin>();
        this.loadBasePlugins(plugins, EnumerationTypeHandlerPlugin.class, new TypeDeclaration[0]);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), EnumerationTypeHandlerPlugin.class));
        }
        return new EnumerationTypeHandlerPlugin.Composite(plugins);
    }

    @Override
    public ArrayTypeHandlerPlugin pluginsForArrays(TypeDeclaration ... typeDeclarations) {
        List data = Annotations.PLUGINS.get(Collections.emptyList(), (Annotable)this.api, (Annotable[])typeDeclarations);
        HashSet<ArrayTypeHandlerPlugin> plugins = new HashSet<ArrayTypeHandlerPlugin>();
        this.loadBasePlugins(plugins, ArrayTypeHandlerPlugin.class, new TypeDeclaration[0]);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), ArrayTypeHandlerPlugin.class));
        }
        return new ArrayTypeHandlerPlugin.Composite(plugins);
    }

    @Override
    public UnionTypeHandlerPlugin pluginsForUnions(TypeDeclaration ... typeDeclarations) {
        List data = Annotations.PLUGINS.get(Collections.emptyList(), (Annotable)this.api, (Annotable[])typeDeclarations);
        HashSet<UnionTypeHandlerPlugin> plugins = new HashSet<UnionTypeHandlerPlugin>();
        this.loadBasePlugins(plugins, UnionTypeHandlerPlugin.class, new TypeDeclaration[0]);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), UnionTypeHandlerPlugin.class));
        }
        return new UnionTypeHandlerPlugin.Composite(plugins);
    }

    @Override
    public ReferenceTypeHandlerPlugin pluginsForReferences(TypeDeclaration ... typeDeclarations) {
        List data = Annotations.PLUGINS.get(Collections.emptyList(), (Annotable)this.api, (Annotable[])typeDeclarations);
        HashSet<ReferenceTypeHandlerPlugin> plugins = new HashSet<ReferenceTypeHandlerPlugin>();
        this.loadBasePlugins(plugins, ReferenceTypeHandlerPlugin.class, new TypeDeclaration[0]);
        for (PluginDef datum : data) {
            plugins.addAll(this.pluginManager.getClassesForName(datum.getPluginName(), datum.getArguments(), ReferenceTypeHandlerPlugin.class));
        }
        return new ReferenceTypeHandlerPlugin.Composite(plugins);
    }

    @Override
    public Api api() {
        return this.api;
    }
}

