/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.array;

import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.ArrayPluginContextImpl;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ArrayTypeHandler
implements TypeHandler {
    private final String name;
    private final ArrayTypeDeclaration typeDeclaration;

    public ArrayTypeHandler(String name, ArrayTypeDeclaration arrayTypeDeclaration) {
        this.name = name;
        this.typeDeclaration = arrayTypeDeclaration;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        ArrayPluginContextImpl arrayPluginContext = new ArrayPluginContextImpl(generationContext, null);
        return generationContext.pluginsForArrays(Utils.allParents((TypeDeclaration)this.typeDeclaration, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0])).className(arrayPluginContext, (TypeDeclaration)this.typeDeclaration, generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE), EventType.INTERFACE);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        if (this.name.contains("[") || this.name.equals("array")) {
            String itemTypeName = this.typeDeclaration.items().name();
            if ("object".equals(itemTypeName)) {
                itemTypeName = this.typeDeclaration.items().type();
            }
            if ("object".equals(itemTypeName)) {
                throw new GenerationException("unable to create type array item of type object (or maybe an inline array type ?)");
            }
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeDeclarationType.calculateTypeName(itemTypeName, this.typeDeclaration.items(), generationContext, type).box()});
        }
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult preCreationResult) {
        ClassName className = preCreationResult.getJavaName(EventType.INTERFACE);
        ArrayPluginContextImpl arrayPluginContext = new ArrayPluginContextImpl(generationContext, preCreationResult);
        TypeDeclaration items = this.typeDeclaration.items();
        ClassName itemsTypeName = ClassName.get(Object.class);
        if (TypeDeclarationType.isNewInlineType(items)) {
            Optional<CreationResult> cr = TypeDeclarationType.createInlineType(className, preCreationResult.getJavaName(EventType.IMPLEMENTATION), Names.typeName(items.type(), "type"), items, generationContext);
            if (cr.isPresent()) {
                preCreationResult.withInternalType(items.name(), (CreationResult)cr.get());
                itemsTypeName = ((CreationResult)cr.get()).getJavaName(EventType.INTERFACE);
            }
        } else {
            itemsTypeName = this.findType(items.name(), items, generationContext).box();
        }
        TypeSpec.Builder arrayClassBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{itemsTypeName}));
        arrayClassBuilder = generationContext.pluginsForArrays(new TypeDeclaration[]{this.typeDeclaration}).classCreated(arrayPluginContext, (TypeDeclaration)this.typeDeclaration, arrayClassBuilder, EventType.INTERFACE);
        return Optional.of((Object)preCreationResult.withInterface(arrayClassBuilder.build()));
    }

    private TypeName findType(String typeName, TypeDeclaration type, GenerationContext generationContext) {
        return TypeDeclarationType.calculateTypeName(typeName, type, generationContext, EventType.INTERFACE);
    }
}

