/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.utils;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.extensions.utils.TypeCopyHandler;

public class TypeCopier {
    private final TypeCopyHandler handler;

    public TypeCopier(TypeCopyHandler handler) {
        this.handler = handler;
    }

    public TypeSpec.Builder copy(TypeSpec.Builder builder, String name) {
        TypeSpec type = builder.build();
        TypeSpec.Builder newType = this.handler.newType(type);
        for (AnnotationSpec annotationSpec : type.annotations) {
            this.handler.handleAnnotations(newType, annotationSpec);
        }
        for (Modifier modifier : type.modifiers) {
            this.handler.handleModifier(newType, modifier);
        }
        for (TypeVariableName typeVariableName : type.typeVariables) {
            this.handler.handleTypeVariable(newType, typeVariableName);
        }
        for (TypeName typeName : type.superinterfaces) {
            this.handler.handleSuperInterface(newType, typeName);
        }
        for (FieldSpec fieldSpec : type.fieldSpecs) {
            this.handler.handleField(newType, fieldSpec);
        }
        for (MethodSpec methodSpec : type.methodSpecs) {
            this.handler.handleMethod(newType, methodSpec);
        }
        for (TypeSpec typeSpec : type.typeSpecs) {
            this.handler.handleTypeSpec(newType, typeSpec);
        }
        for (Map.Entry entry : type.enumConstants.entrySet()) {
            this.handler.handleEnumConstant(newType, (String)entry.getKey(), (TypeSpec)entry.getValue());
        }
        if (type.javadoc != null) {
            this.handler.handleJavadoc(newType, type.javadoc);
        }
        if (type.superclass != null) {
            this.handler.handleSuperclass(newType, type.superclass);
        }
        if (type.staticBlock != null && !type.staticBlock.isEmpty()) {
            this.handler.handleStaticBlock(newType, type.staticBlock);
        }
        if (type.initializerBlock != null && !type.initializerBlock.isEmpty()) {
            this.handler.handleInitializerBlock(newType, type.initializerBlock);
        }
        return newType;
    }
}

