/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.ramltopojo.PluginDef;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;

public abstract class Annotations<T> {
    public static Annotations<Boolean> ABSTRACT = new Annotations<Boolean>(){

        @Override
        public Boolean getWithContext(Annotable target, Annotable ... others) {
            return (Boolean)Annotations.getWithDefault(new TypeInstanceAsBooleanFunction(), "abstract", false, target, others);
        }
    };
    public static Annotations<Boolean> USE_PRIMITIVE = new Annotations<Boolean>(){

        @Override
        public Boolean getWithContext(Annotable target, Annotable ... others) {
            return (Boolean)Annotations.getWithDefault(new TypeInstanceAsBooleanFunction(), "usePrimitiveType", true, target, others);
        }
    };
    public static Annotations<Boolean> GENERATE_INLINE_ARRAY_TYPE = new Annotations<Boolean>(){

        @Override
        public Boolean getWithContext(Annotable target, Annotable ... others) {
            return (Boolean)Annotations.getWithDefault(new TypeInstanceAsBooleanFunction(), "generateInlineArrayType", false, target, others);
        }
    };
    public static Annotations<String> IMPLEMENTATION_CLASS_NAME = new Annotations<String>(){

        @Override
        public String getWithContext(Annotable target, Annotable ... others) {
            return (String)Annotations.getWithDefault(new TypeInstanceAsBooleanFunction(), "implementationClassName", null, target, others);
        }
    };
    public static Annotations<String> CLASS_NAME = new Annotations<String>(){

        @Override
        public String getWithContext(Annotable target, Annotable ... others) {
            return (String)Annotations.getWithDefault(new TypeInstanceAsBooleanFunction(), "className", null, target, others);
        }
    };
    public static Annotations<List<PluginDef>> PLUGINS = new Annotations<List<PluginDef>>(){

        @Override
        public List<PluginDef> getWithContext(Annotable target, Annotable ... others) {
            return Annotations.getWithDefaultList(new TypeInstanceToPluginDefFunction(), "plugins", target, others);
        }
    };

    private static <T, R> R getWithDefault(Function<TypeInstance, T> convert, String propName, R def, Annotable target, Annotable ... others) {
        R b = Annotations.evaluate(convert, "types", propName, target, others);
        if (b == null) {
            return def;
        }
        return b;
    }

    private static <T, R> List<R> getWithDefaultList(Function<TypeInstance, T> convert, String propName, Annotable target, Annotable ... others) {
        List<R> b = Annotations.evaluateAsList(convert, "types", propName, target, others);
        if (b == null) {
            return Collections.emptyList();
        }
        return b;
    }

    public static <T, R> R evaluate(Function<TypeInstance, T> convert, String annotationName, String parameterName, Annotable mandatory, Annotable ... others) {
        Object retval = null;
        ArrayList<Annotable> targets = new ArrayList<Annotable>();
        targets.add(mandatory);
        targets.addAll(Arrays.asList(others));
        for (Annotable target : targets) {
            Object o;
            AnnotationRef annotationRef = Annotations.findRef(target, annotationName);
            if (annotationRef == null || (o = Annotations.findProperty(annotationRef, parameterName, convert)) == null) continue;
            retval = o;
        }
        return (R)retval;
    }

    public static <T, R> List<R> evaluateAsList(Function<TypeInstance, T> convert, String annotationName, String parameterName, Annotable mandatory, Annotable ... others) {
        ArrayList<Annotable> targets = new ArrayList<Annotable>();
        targets.add(mandatory);
        targets.addAll(Arrays.asList(others));
        ArrayList finalList = new ArrayList();
        for (Annotable target : targets) {
            Object o;
            AnnotationRef annotationRef = Annotations.findRef(target, annotationName);
            if (annotationRef == null || (o = Annotations.findProperty(annotationRef, parameterName, convert)) == null) continue;
            finalList.addAll((List)o);
        }
        return finalList;
    }

    private static <T> Object findProperty(AnnotationRef annotationRef, String propName, Function<TypeInstance, T> convert) {
        for (TypeInstanceProperty typeInstanceProperty : annotationRef.structuredValue().properties()) {
            if (!typeInstanceProperty.name().equalsIgnoreCase(propName)) continue;
            if (typeInstanceProperty.isArray().booleanValue()) {
                return Annotations.toValueList(convert, typeInstanceProperty.values());
            }
            return convert.apply((Object)typeInstanceProperty.value());
        }
        return null;
    }

    private static <T> List<T> toValueList(final Function<TypeInstance, T> convert, List<TypeInstance> values) {
        return Lists.transform(values, (Function)new Function<TypeInstance, T>(){

            @Nullable
            public T apply(@Nullable TypeInstance input) {
                return convert.apply((Object)input);
            }
        });
    }

    public static AnnotationRef findRef(Annotable annotable, String annotation) {
        for (AnnotationRef annotationRef : annotable.annotations()) {
            if (!annotationRef.annotation().name().equalsIgnoreCase(annotation)) continue;
            return annotationRef;
        }
        return null;
    }

    public abstract T getWithContext(Annotable var1, Annotable ... var2);

    public T getValueWithDefault(T def, Annotable annotable, Annotable ... others) {
        T t = this.getWithContext(annotable, others);
        if (t == null) {
            return def;
        }
        return t;
    }

    public T get(T def, Annotable type) {
        return this.getValueWithDefault(def, type, new Annotable[0]);
    }

    public T get(Annotable type) {
        return this.getValueWithDefault(null, type, new Annotable[0]);
    }

    public T get(T def, Annotable type, Annotable ... others) {
        return this.getValueWithDefault(def, type, others);
    }

    private static class TypeInstanceToPluginDefFunction
    implements Function<TypeInstance, PluginDef> {
        private TypeInstanceToPluginDefFunction() {
        }

        public PluginDef apply(@Nullable TypeInstance input) {
            if (input.properties().size() == 0) {
                return new PluginDef((String)input.value(), Collections.emptyList());
            }
            if (input.properties().size() == 1) {
                return new PluginDef((String)((TypeInstanceProperty)input.properties().get(0)).value().value(), Collections.emptyList());
            }
            return new PluginDef((String)((TypeInstanceProperty)input.properties().get(0)).value().value(), Lists.transform((List)((TypeInstanceProperty)input.properties().get(1)).values(), (Function)new Function<TypeInstance, String>(){

                @Nullable
                public String apply(@Nullable TypeInstance input) {
                    return (String)input.value();
                }
            }));
        }
    }

    private static class TypeInstanceAsBooleanFunction
    implements Function<TypeInstance, Boolean> {
        private TypeInstanceAsBooleanFunction() {
        }

        @Nullable
        public Boolean apply(@Nullable TypeInstance input) {
            return (Boolean)input.value();
        }
    }

    private static class TypeInstanceAsStringFunction
    implements Function<TypeInstance, String> {
        private TypeInstanceAsStringFunction() {
        }

        @Nullable
        public String apply(@Nullable TypeInstance input) {
            return (String)input.value();
        }
    }
}

