/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JacksonBasicExtension
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration obj, TypeSpec.Builder typeSpec, EventType eventType) {
        if (eventType != EventType.IMPLEMENTATION) {
            return typeSpec;
        }
        typeSpec.addAnnotation(AnnotationSpec.builder(JsonInclude.class).addMember("value", "$T.$L", new Object[]{JsonInclude.Include.class, "NON_NULL"}).build());
        if (obj.discriminatorValue() != null) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonTypeName.class).addMember("value", "$S", new Object[]{obj.discriminatorValue()}).build());
        }
        AnnotationSpec.Builder builder = AnnotationSpec.builder(JsonPropertyOrder.class);
        for (TypeDeclaration declaration : obj.properties()) {
            if (EcmaPattern.isSlashedPattern(declaration.name())) continue;
            builder.addMember("value", "$S", new Object[]{declaration.name()});
        }
        typeSpec.addAnnotation(builder.build());
        return typeSpec;
    }

    @Override
    public FieldSpec.Builder fieldBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, FieldSpec.Builder fieldSpec, EventType eventType) {
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()});
        if (declaration.defaultValue() != null) {
            annotation.addMember("defaultValue", "$S", new Object[]{declaration.defaultValue()});
        }
        return fieldSpec.addAnnotation(annotation.build());
    }

    @Override
    public MethodSpec.Builder getterBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, MethodSpec.Builder methodSpec, EventType eventType) {
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()});
        if (declaration.defaultValue() != null) {
            annotation.addMember("defaultValue", "$S", new Object[]{declaration.defaultValue()});
        }
        return methodSpec.addAnnotation(annotation.build());
    }

    @Override
    public MethodSpec.Builder setterBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, MethodSpec.Builder methodSpec, EventType eventType) {
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{declaration.name()});
        if (declaration.defaultValue() != null) {
            annotation.addMember("defaultValue", "$S", new Object[]{declaration.defaultValue()});
        }
        return methodSpec.addAnnotation(annotation.build());
    }
}

