/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.object;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectPluginContextImpl;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class ObjectTypeHandler
implements TypeHandler {
    public static final String DISCRIMINATOR_TYPE_NAME = "_DISCRIMINATOR_TYPE_NAME";
    private final String name;
    private final ObjectTypeDeclaration objectTypeDeclaration;
    private static final ParameterizedTypeName ADDITIONAL_PROPERTIES_TYPE = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});

    public ObjectTypeHandler(String name, ObjectTypeDeclaration objectTypeDeclaration) {
        this.name = name;
        this.objectTypeDeclaration = objectTypeDeclaration;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        ObjectPluginContextImpl context = new ObjectPluginContextImpl(generationContext, null);
        ObjectTypeHandlerPlugin plugin = generationContext.pluginsForObjects(Utils.allParents((TypeDeclaration)this.objectTypeDeclaration, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0]));
        ClassName className = type == EventType.IMPLEMENTATION ? generationContext.buildDefaultClassName(Names.typeName(this.name, "Impl"), EventType.IMPLEMENTATION) : generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE);
        return plugin.className(context, this.objectTypeDeclaration, className, type);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult result) {
        ObjectPluginContextImpl context = new ObjectPluginContextImpl(generationContext, result);
        TypeSpec interfaceSpec = this.createInterface(context, result, generationContext);
        TypeSpec implementationSpec = this.createImplementation(context, result, generationContext);
        if (interfaceSpec == null) {
            return Optional.absent();
        }
        return Optional.of((Object)result.withInterface(interfaceSpec).withImplementation(implementationSpec));
    }

    private TypeSpec createImplementation(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext) {
        ClassName className = result.getJavaName(EventType.IMPLEMENTATION);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)className).addSuperinterface((TypeName)result.getJavaName(EventType.INTERFACE)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional discriminator = Optional.fromNullable((Object)this.objectTypeDeclaration.discriminator());
        for (TypeDeclaration propertyDeclaration : this.objectTypeDeclaration.properties()) {
            TypeName tn;
            if (EcmaPattern.isSlashedPattern(propertyDeclaration.name())) continue;
            if (TypeDeclarationType.isNewInlineType(propertyDeclaration)) {
                CreationResult cr = result.internalType(propertyDeclaration.name());
                if (cr.getImplementation().isPresent() && propertyDeclaration instanceof UnionTypeDeclaration) {
                    TypeSpec.Builder innerTypeSpecImpl = ((TypeSpec)cr.getImplementation().get()).toBuilder();
                    typeSpec.addType(innerTypeSpecImpl.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build());
                }
                tn = cr.getJavaName(EventType.INTERFACE);
            } else {
                tn = this.findType(propertyDeclaration.type(), propertyDeclaration, generationContext, EventType.INTERFACE);
            }
            FieldSpec.Builder field = FieldSpec.builder((TypeName)tn, (String)Names.variableName(propertyDeclaration.name()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
            if (propertyDeclaration.name().equals(discriminator.orNull())) {
                String discriminatorValue = (String)Optional.fromNullable((Object)this.objectTypeDeclaration.discriminatorValue()).or((Object)this.objectTypeDeclaration.name());
                field.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(CodeBlock.builder().add("$L", new Object[]{DISCRIMINATOR_TYPE_NAME}).build());
            }
            if ((field = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).fieldBuilt(objectPluginContext, propertyDeclaration, field, EventType.IMPLEMENTATION)) != null) {
                typeSpec.addField(field.build());
            }
            MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)Names.methodName("get", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("return this." + Names.variableName(propertyDeclaration.name()), new Object[0]).build()).returns(tn);
            getMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).getterBuilt(objectPluginContext, propertyDeclaration, getMethod, EventType.IMPLEMENTATION);
            if (getMethod != null) {
                typeSpec.addMethod(getMethod.build());
            }
            if (propertyDeclaration.name().equals(discriminator.orNull())) continue;
            MethodSpec.Builder setMethod = MethodSpec.methodBuilder((String)Names.methodName("set", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("this." + Names.variableName(propertyDeclaration.name()) + " = " + Names.variableName(propertyDeclaration.name()), new Object[0]).build()).addParameter(tn, Names.variableName(propertyDeclaration.name()), new Modifier[0]);
            setMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).setterBuilt(objectPluginContext, propertyDeclaration, setMethod, EventType.IMPLEMENTATION);
            if (setMethod == null) continue;
            typeSpec.addMethod(setMethod.build());
        }
        if (this.objectTypeDeclaration.additionalProperties().booleanValue()) {
            this.handleAdditionalPropertiesImplementation(objectPluginContext, result, generationContext, typeSpec);
        }
        if ((typeSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).classCreated(objectPluginContext, this.objectTypeDeclaration, typeSpec, EventType.IMPLEMENTATION)) == null) {
            return null;
        }
        return typeSpec.build();
    }

    private TypeSpec createInterface(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext) {
        ClassName interf = result.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((ClassName)interf).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        typeSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).classCreated(objectPluginContext, this.objectTypeDeclaration, typeSpec, EventType.INTERFACE);
        if (typeSpec == null) {
            return null;
        }
        Optional discriminator = Optional.fromNullable((Object)this.objectTypeDeclaration.discriminator());
        for (TypeDeclaration typeDeclaration : this.objectTypeDeclaration.parentTypes()) {
            if (typeDeclaration instanceof ObjectTypeDeclaration) {
                if (typeDeclaration.name().equals("object")) continue;
                TypeName inherits = this.findType(typeDeclaration.name(), typeDeclaration, generationContext, EventType.INTERFACE);
                typeSpec.addSuperinterface(inherits);
                continue;
            }
            throw new GenerationException("ramltopojo does not support inheriting from " + Utils.declarationType(typeDeclaration) + " name: " + typeDeclaration.name() + " and " + typeDeclaration.type());
        }
        for (TypeDeclaration propertyDeclaration : this.objectTypeDeclaration.properties()) {
            if (EcmaPattern.isSlashedPattern(propertyDeclaration.name())) continue;
            TypeName tn = null;
            if (TypeDeclarationType.isNewInlineType(propertyDeclaration)) {
                Object cr;
                if (propertyDeclaration instanceof UnionTypeDeclaration) {
                    cr = (CreationResult)TypeDeclarationType.createInlineType(interf, result.getJavaName(EventType.IMPLEMENTATION), Names.typeName(propertyDeclaration.type(), "union"), propertyDeclaration, generationContext).get();
                    result.withInternalType(propertyDeclaration.name(), (CreationResult)cr);
                    tn = ((CreationResult)cr).getJavaName(EventType.INTERFACE);
                    typeSpec.addType(((CreationResult)cr).getInterface().toBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build());
                } else {
                    cr = TypeDeclarationType.createInlineType(interf, result.getJavaName(EventType.IMPLEMENTATION), Names.typeName(propertyDeclaration.name(), "type"), propertyDeclaration, generationContext);
                    if (cr.isPresent()) {
                        result.withInternalType(propertyDeclaration.name(), (CreationResult)cr.get());
                        tn = ((CreationResult)cr.get()).getJavaName(EventType.INTERFACE);
                    }
                }
            } else {
                tn = this.findType(propertyDeclaration.type(), propertyDeclaration, generationContext, EventType.INTERFACE);
            }
            if (tn == null) continue;
            MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)Names.methodName("get", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(tn);
            getMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).getterBuilt(objectPluginContext, propertyDeclaration, getMethod, EventType.INTERFACE);
            if (getMethod != null) {
                typeSpec.addMethod(getMethod.build());
                if (propertyDeclaration.name().equals(discriminator.orNull())) {
                    String discriminatorValue = (String)Optional.fromNullable((Object)this.objectTypeDeclaration.discriminatorValue()).or((Object)this.objectTypeDeclaration.name());
                    typeSpec.addField(FieldSpec.builder(String.class, (String)DISCRIMINATOR_TYPE_NAME, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer(CodeBlock.builder().add("$S", new Object[]{discriminatorValue}).build()).build());
                    continue;
                }
            }
            MethodSpec.Builder setMethod = MethodSpec.methodBuilder((String)Names.methodName("set", propertyDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(tn, Names.variableName(propertyDeclaration.name()), new Modifier[0]);
            setMethod = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration, propertyDeclaration}).setterBuilt(objectPluginContext, propertyDeclaration, setMethod, EventType.INTERFACE);
            if (setMethod == null) continue;
            typeSpec.addMethod(setMethod.build());
        }
        if (this.objectTypeDeclaration.additionalProperties().booleanValue()) {
            this.handleAdditionalPropertiesInterface(objectPluginContext, result, generationContext, typeSpec);
        }
        return typeSpec.build();
    }

    private void handleAdditionalPropertiesInterface(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext, TypeSpec.Builder typeSpec) {
        MethodSpec.Builder getAdditionalProperties = MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        MethodSpec.Builder getSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).additionalPropertiesGetterBuilt(objectPluginContext, getAdditionalProperties, EventType.INTERFACE);
        if (getSpec != null) {
            typeSpec.addMethod(getSpec.build());
        }
        MethodSpec.Builder setAdditionalProperties = MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        MethodSpec.Builder setSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).additionalPropertiesSetterBuilt(objectPluginContext, setAdditionalProperties, EventType.INTERFACE);
        if (setSpec != null) {
            typeSpec.addMethod(setSpec.build());
        }
    }

    private void handleAdditionalPropertiesImplementation(ObjectPluginContext objectPluginContext, CreationResult result, GenerationContext generationContext, TypeSpec.Builder typeSpec) {
        TypeName newSpec = objectPluginContext.createSupportClass(this.buildSpecialMap());
        FieldSpec.Builder additionalPropertiesField = FieldSpec.builder((TypeName)ADDITIONAL_PROPERTIES_TYPE, (String)"additionalProperties", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer(this.withProperties(newSpec, this.objectTypeDeclaration).build());
        FieldSpec.Builder fieldSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).additionalPropertiesFieldBuilt(objectPluginContext, additionalPropertiesField, EventType.IMPLEMENTATION);
        if (fieldSpec != null) {
            typeSpec.addField(fieldSpec.build());
        }
        MethodSpec.Builder getAdditionalProperties = MethodSpec.methodBuilder((String)"getAdditionalProperties").returns((TypeName)ADDITIONAL_PROPERTIES_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("return additionalProperties;\n", new Object[0]);
        MethodSpec.Builder getSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).additionalPropertiesGetterBuilt(objectPluginContext, getAdditionalProperties, EventType.IMPLEMENTATION);
        if (getSpec != null) {
            typeSpec.addMethod(getSpec.build());
        }
        MethodSpec.Builder setAdditionalProperties = MethodSpec.methodBuilder((String)"setAdditionalProperties").returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(String.class), (String)"key", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().add("this.additionalProperties.put(key, value);\n", new Object[0]).build());
        MethodSpec.Builder setSpec = generationContext.pluginsForObjects(new TypeDeclaration[]{this.objectTypeDeclaration}).additionalPropertiesSetterBuilt(objectPluginContext, setAdditionalProperties, EventType.IMPLEMENTATION);
        if (setSpec != null) {
            typeSpec.addMethod(setSpec.build());
        }
    }

    private CodeBlock.Builder withProperties(TypeName newSpec, ObjectTypeDeclaration object) {
        ImmutableList properties = FluentIterable.from((Iterable)object.properties()).filter((Predicate)new Predicate<TypeDeclaration>(){

            public boolean apply(@Nullable TypeDeclaration property) {
                return property != null && EcmaPattern.isSlashedPattern(property.name()) && !EcmaPattern.fromString(property.name()).asJavaPattern().isEmpty();
            }
        }).toList();
        if (properties.size() == 0) {
            return CodeBlock.of((String)"new $T()", (Object[])new Object[]{newSpec}).toBuilder();
        }
        CodeBlock.Builder cb = CodeBlock.builder().beginControlFlow("new $T()", new Object[]{newSpec}).beginControlFlow("", new Object[0]);
        for (TypeDeclaration typeDeclaration : object.properties()) {
            cb.addStatement("addAcceptedPattern($T.compile($S))", new Object[]{Pattern.class, EcmaPattern.fromString(typeDeclaration.name()).asJavaPattern()});
        }
        return cb.endControlFlow().endControlFlow();
    }

    protected TypeSpec.Builder buildSpecialMap() {
        return TypeSpec.classBuilder((String)"ExcludingMap").superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)})).addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)"serialVersionUID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("1L", new Object[0]).build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{Pattern.class}), (String)"additionalProperties", (Modifier[])new Modifier[0]).initializer(CodeBlock.builder().add(" new $T()", new Object[]{ParameterizedTypeName.get(HashSet.class, (Type[])new Type[]{Pattern.class})}).build()).build()).addMethod(MethodSpec.methodBuilder((String)"put").addParameter((TypeName)ClassName.get(String.class), "key", new Modifier[0]).addParameter((TypeName)ClassName.get(Object.class), "value", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeName.OBJECT).beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("return setProperty(key, value)", new Object[0]).endControlFlow().build()).addMethod(MethodSpec.methodBuilder((String)"putAll").addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(String.class), WildcardTypeName.subtypeOf(Object.class)}), "otherMap", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addCode(CodeBlock.builder().beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("super.putAll(otherMap)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).beginControlFlow("for ( $T<? extends $T, ?> entry : otherMap.entrySet() )", new Object[]{Map.Entry.class, String.class}).addStatement("setProperty(entry.getKey(), entry.getValue())", new Object[0]).endControlFlow().endControlFlow().build()).build()).addMethod(MethodSpec.methodBuilder((String)"addAcceptedPattern").addParameter((TypeName)ClassName.get(Pattern.class), "pattern", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.VOID).addCode(CodeBlock.builder().addStatement("additionalProperties.add(pattern)", new Object[0]).build()).build()).addMethod(MethodSpec.methodBuilder((String)"setProperty").addParameter((TypeName)ClassName.get(String.class), "key", new Modifier[0]).addParameter((TypeName)ClassName.get(Object.class), "value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)TypeName.OBJECT).beginControlFlow("if ( additionalProperties.size() == 0 ) ", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).beginControlFlow("for ( $T p : additionalProperties)", new Object[]{Pattern.class}).beginControlFlow("if ( p.matcher(key).matches() )", new Object[0]).addStatement("return super.put(key, value)", new Object[0]).endControlFlow().endControlFlow().addStatement("throw new $T(\"property \" + key + \" is invalid according to RAML type\")", new Object[]{IllegalArgumentException.class}).endControlFlow().build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private TypeName findType(String typeName, TypeDeclaration type, GenerationContext generationContext, EventType eventType) {
        return TypeDeclarationType.calculateTypeName(typeName, type, generationContext, eventType);
    }
}

